<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
// Frontend Routes
$routes->get('/', 'HomeController::index');
$routes->get('/biodata', 'BiodataController::index');
$routes->get('/activities', 'ActivitiesController::index');
$routes->get('/education', 'EducationController::index');
$routes->get('/work', 'WorkController::index');
$routes->get('/training', 'TrainingController::index');
$routes->get('/projects', 'ProjectsController::index');
$routes->get('/organizations', 'OrganizationsController::index');
$routes->get('/certificates', 'CertificatesController::index');

// Auth Routes
$routes->get('/auth/login', 'AuthController::selectRole');
$routes->get('/auth/login/(:segment)', 'AuthController::login/$1');
$routes->post('/auth/login/(:segment)', 'AuthController::processLogin/$1');
$routes->get('/auth/logout', 'AuthController::logout');

// Image Serving Routes
$routes->get('images/(:segment)/(:segment)', 'ImageController::serve/$1/$2');
$routes->get('placeholder/(:num)/(:num)', 'ImageController::placeholder/$1/$2');

// AI Generator Routes
$routes->group('api/ai', function($routes) {
    $routes->post('generate-education', 'AIGeneratorController::generateEducationDescription');
    $routes->post('generate-work', 'AIGeneratorController::generateWorkDescription');
    $routes->post('generate-training', 'AIGeneratorController::generateTrainingDescription');
    $routes->post('generate-project', 'AIGeneratorController::generateProjectDescription');
    $routes->post('generate-organization', 'AIGeneratorController::generateOrganizationDescription');
    $routes->post('generate-certificate', 'AIGeneratorController::generateCertificateDescription');
    $routes->post('generate-activity', 'AIGeneratorController::generateActivityDescription');
    $routes->post('generate-biodata-profile', 'AIGeneratorController::generateBiodataProfile');
    $routes->post('generate-biodata-description', 'AIGeneratorController::generateBiodataDescription');
    $routes->post('expand-text', 'AIGeneratorController::expandText');
});

// Admin Routes - Dashboard
$routes->group('admin', ['filter' => 'auth'], function($routes) {
    $routes->get('dashboard', 'Admin\DashboardController::index');
    $routes->get('logout', 'AuthController::logout');
    
    // Admin Activities
    $routes->group('activities', ['filter' => 'admin_activities'], function($routes) {
        $routes->get('/', 'Admin\ActivitiesController::index');
        $routes->get('create', 'Admin\ActivitiesController::create');
        $routes->post('store', 'Admin\ActivitiesController::store');
        $routes->get('edit/(:num)', 'Admin\ActivitiesController::edit/$1');
        $routes->post('update/(:num)', 'Admin\ActivitiesController::update/$1');
        $routes->get('delete/(:num)', 'Admin\ActivitiesController::delete/$1');
    });
    
    // Admin Biodata (Hanya untuk satu biodata/CV personal)
    $routes->group('biodata', ['filter' => 'admin_biodata'], function($routes) {
        $routes->get('/', 'Admin\BiodataController::index');
        $routes->get('create', 'Admin\BiodataController::create');
        $routes->post('store', 'Admin\BiodataController::store');
        $routes->get('edit', 'Admin\BiodataController::edit');
        $routes->post('update', 'Admin\BiodataController::update');
    });
    
    // Admin Education (Riwayat Pendidikan dan Kerja)
    $routes->group('education', ['filter' => 'admin_education'], function($routes) {
        $routes->get('/', 'Admin\EducationController::index');
        $routes->get('create', 'Admin\EducationController::create');
        $routes->post('store', 'Admin\EducationController::store');
        $routes->get('edit/(:num)', 'Admin\EducationController::edit/$1');
        $routes->post('update/(:num)', 'Admin\EducationController::update/$1');
        $routes->get('delete/(:num)', 'Admin\EducationController::delete/$1');
    });
    
    // Admin Work Experience
    $routes->group('work', ['filter' => 'admin_biodata'], function($routes) {
        $routes->get('/', 'Admin\WorkController::index');
        $routes->get('create', 'Admin\WorkController::create');
        $routes->post('store', 'Admin\WorkController::store');
        $routes->get('edit/(:num)', 'Admin\WorkController::edit/$1');
        $routes->post('update/(:num)', 'Admin\WorkController::update/$1');
        $routes->get('delete/(:num)', 'Admin\WorkController::delete/$1');
    });
    
    // Admin Training
    $routes->group('training', ['filter' => 'admin_biodata'], function($routes) {
        $routes->get('/', 'Admin\TrainingController::index');
        $routes->get('create', 'Admin\TrainingController::create');
        $routes->post('store', 'Admin\TrainingController::store');
        $routes->get('edit/(:num)', 'Admin\TrainingController::edit/$1');
        $routes->post('update/(:num)', 'Admin\TrainingController::update/$1');
        $routes->get('delete/(:num)', 'Admin\TrainingController::delete/$1');
    });
    
    // Admin Projects
    $routes->group('projects', ['filter' => 'admin_biodata'], function($routes) {
        $routes->get('/', 'Admin\ProjectsController::index');
        $routes->get('create', 'Admin\ProjectsController::create');
        $routes->post('store', 'Admin\ProjectsController::store');
        $routes->get('edit/(:num)', 'Admin\ProjectsController::edit/$1');
        $routes->post('update/(:num)', 'Admin\ProjectsController::update/$1');
        $routes->get('delete/(:num)', 'Admin\ProjectsController::delete/$1');
    });
    
    // Admin Organizations
    $routes->group('organizations', ['filter' => 'admin_biodata'], function($routes) {
        $routes->get('/', 'Admin\OrganizationsController::index');
        $routes->get('create', 'Admin\OrganizationsController::create');
        $routes->post('store', 'Admin\OrganizationsController::store');
        $routes->get('edit/(:num)', 'Admin\OrganizationsController::edit/$1');
        $routes->post('update/(:num)', 'Admin\OrganizationsController::update/$1');
        $routes->get('delete/(:num)', 'Admin\OrganizationsController::delete/$1');
    });
    
    // Admin Certificates
    $routes->group('certificates', ['filter' => 'admin_biodata'], function($routes) {
        $routes->get('/', 'Admin\CertificatesController::index');
        $routes->get('create', 'Admin\CertificatesController::create');
        $routes->post('store', 'Admin\CertificatesController::store');
        $routes->get('edit/(:num)', 'Admin\CertificatesController::edit/$1');
        $routes->post('update/(:num)', 'Admin\CertificatesController::update/$1');
        $routes->get('delete/(:num)', 'Admin\CertificatesController::delete/$1');
    });
});
